<?php

/**
 * Lithuanian language file
 *
 * 
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Aurimas Fišeras <aurimas@gmail.com>
 * @copyright 2009-2020 Aurimas Fišeras, UAB „Avakompas“, phpMyFAQ Team
 * @license http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2009-07-12
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "lt";
$PMF_LANG["language"] = "lietuvių";
// ltr: left to right (e.g. English language); rtl: right to left (e.g. Arabic language)
$PMF_LANG["dir"] = "ltr";

$PMF_LANG["nplurals"] = "3";
/**
 * This parameter is used with the function 'plural' from inc/Language/Plurals.php
 * If this parameter and function are not in sync plural form support will be broken.
 */

// Navigation
$PMF_LANG["msgCategory"] = "Grupės";
$PMF_LANG["msgShowAllCategories"] = "Visos grupės";
$PMF_LANG["msgSearch"] = "Paieška";
$PMF_LANG["msgAddContent"] = "Pridėti DUK";
$PMF_LANG["msgQuestion"] = "Užduoti klausimą";
$PMF_LANG["msgOpenQuestions"] = "Atviri klausimai";
$PMF_LANG["msgHelp"] = "Žinynas";
$PMF_LANG["msgContact"] = "Susisiekti";
$PMF_LANG["msgHome"] = "DUK pradžia";
$PMF_LANG["msgNews"] = "DUK naujienos";
$PMF_LANG["msgUserOnline"] = " prisijungę naudotojai";
$PMF_LANG["msgBack2Home"] = "Grįžti į pagrindinį tinklalapį";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Grupės su DUK";
$PMF_LANG["msgFullCategoriesIn"] = "Grupės su DUK iš ";
$PMF_LANG["msgSubCategories"] = "Pogrupiai";
$PMF_LANG["msgEntries"] = "DUK";
$PMF_LANG["msgEntriesIn"] = "Klausimai iš ";
$PMF_LANG["msgViews"] = "peržiūros";
$PMF_LANG["msgPage"] = "Puslapis ";
$PMF_LANG["msgPages"] = " puslapiai";
$PMF_LANG["msgPrevious"] = "ankstesnis";
$PMF_LANG["msgNext"] = "tolesnis";
$PMF_LANG["msgCategoryUp"] = "viena grupe aukštyn";
$PMF_LANG["msgLastUpdateArticle"] = "Paskutinis atnaujinimas: ";
$PMF_LANG["msgAuthor"] = "Autorius: ";
$PMF_LANG["msgPrinterFriendly"] = "Versija spausdinimui";
$PMF_LANG["msgPrintArticle"] = "Spausdinti šį įrašą";
$PMF_LANG["msgMakeXMLExport"] = "Eksportuoti kaip XML failą";
$PMF_LANG["msgAverageVote"] = "Vidutinis įvertis";
$PMF_LANG["msgVoteUsability"] = "Įvertinti šį DUK";
$PMF_LANG["msgVoteFrom"] = "iš";
$PMF_LANG["msgVoteBad"] = "visiškai nenaudingas";
$PMF_LANG["msgVoteGood"] = "labai vertingas";
$PMF_LANG["msgVotings"] = "balsai";
$PMF_LANG["msgVoteSubmit"] = "Balsuoti";
$PMF_LANG["msgVoteThanks"] = "Labai ačiū už jūsų balsą!";
$PMF_LANG["msgYouCan"] = "Jūs galite ";
$PMF_LANG["msgWriteComment"] = "komentuoti šį DUK";
$PMF_LANG["msgShowCategory"] = "Turinio apžvalga: ";
$PMF_LANG["msgCommentBy"] = "Komentavo ";
$PMF_LANG["msgCommentHeader"] = "Komentuoti šį DUK";
$PMF_LANG["msgYourComment"] = "Jūsų komentaras";
$PMF_LANG["msgCommentThanks"] = "Labai ačiū už jūsų komentarą!";
$PMF_LANG["msgSeeXMLFile"] = "atverti XML failą";
$PMF_LANG["msgSend2Friend"] = "Siųsti DUK draugui";
$PMF_LANG["msgS2FName"] = "Jūsų vardas";
$PMF_LANG["msgS2FEMail"] = "Jūsų el. pašto adresas";
$PMF_LANG["msgS2FFriends"] = "Jūsų draugai";
$PMF_LANG["msgS2FEMails"] = ". el. pašto adresas";
$PMF_LANG["msgS2FText"] = "Bus išsiųstas šis tekstas";
$PMF_LANG["msgS2FText2"] = "Jūs rasite DUK šiuo adresu";
$PMF_LANG["msgS2FMessage"] = "Papildomas pranešimas jūsų draugui";
$PMF_LANG["msgS2FButton"] = "siųsti el. laišką";
$PMF_LANG["msgS2FThx"] = "Ačiū už jūsų rekomendaciją!";
$PMF_LANG["msgS2FMailSubject"] = "Rekomendacija nuo ";

// Search
$PMF_LANG["msgSearchWord"] = "Raktažodis";
$PMF_LANG["msgSearchFind"] = "Paieškos rezultatas ";
$PMF_LANG["msgSearchAmount"] = " paieškos rezultatas";
$PMF_LANG["msgSearchAmounts"] = " paieškos rezultatai";
$PMF_LANG["msgSearchCategory"] = "Grupė: ";
$PMF_LANG["msgSearchContent"] = "Atsakymas: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Naujo DUK pasiūlymas";
$PMF_LANG["msgNewContentAddon"] = "Jūsų pasiūlymas nebus iš karto paskelbtas. Jis bus paskelbtas tik gavus administratoriaus sutikimą. Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>grupė</strong>, <strong>antraštė</strong> ir <strong>jūsų įrašas</strong>. Prašome atskirti raktažodžius tik tarpais.";
$PMF_LANG["msgNewContentName"] = "Jūsų vardas";
$PMF_LANG["msgNewContentMail"] = "Jūsų el. pašto adresas";
$PMF_LANG["msgNewContentCategory"] = "Grupė";
$PMF_LANG["msgNewContentTheme"] = "Klausimas";
$PMF_LANG["msgNewContentArticle"] = "Atsakymas";
$PMF_LANG["msgNewContentKeywords"] = "Raktažodžiai";
$PMF_LANG["msgNewContentLink"] = "Saitas šiam įrašui";
$PMF_LANG["msgNewContentSubmit"] = "išsiųsti";
$PMF_LANG["msgInfo"] = "Daugiau informacijos: ";
$PMF_LANG["msgNewContentThanks"] = "Ačiū už jūsų pasiūlymą!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Šiuo metu nėra klausimų laukiančių sprendimo.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Užduokite savo klausimą žemiau";
$PMF_LANG["msgAskCategory"] = "Grupė";
$PMF_LANG["msgAskYourQuestion"] = "Klausimas";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Ačiū už jūsų klausimą!</h2>";
$PMF_LANG["msgDate_User"] = "Data / naudotojas";
$PMF_LANG["msgQuestion2"] = "Klausimas";
$PMF_LANG["msg2answer"] = "Atsakymas";
$PMF_LANG["msgQuestionText"] = "Čia jūs matote kitų naudotojų užduotus klausimus. Jei atsakysite į šiuos klausimus, jūsų atsakymai gali būti įdėti į DUK.";

// Help
$PMF_LANG["msgHelpText"] = "DUK (<strong>D</strong>ažniausiai <strong>U</strong>žduodami <strong>K</strong>lausimai) struktūra yra gana paprasta. Jūs arba galite ieškoti <strong><a href=\"?action=show\">grupėse</a></strong>, arba naudoti <strong><a href=\"?action=search\">DUK paieškos sistemą</a></strong> raktažodžių paieškai.";

// Contact
$PMF_LANG["msgContactEMail"] = "Siųsti pranešimą svetainės administratoriui";
$PMF_LANG["msgMessage"] = "Jūsų pranešimas";

// Startseite
$PMF_LANG["msgNews"] = " – naujienos";
$PMF_LANG["msgTopTen"] = "Populiariausi DUK";
$PMF_LANG["msgHomeThereAre"] = "Yra pateikti ";
$PMF_LANG["msgHomeArticlesOnline"] = " DUK";
$PMF_LANG["msgNoNews"] = "Tyla – gera byla.";
$PMF_LANG["msgLatestArticles"] = "Naujausi DUK";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Labai ačiū už jūsų DUK pasiūlymą.";
$PMF_LANG["msgMailCheck"] = "Yra naujas DUK įrašas! Prašome patikrinti administratoriaus sekciją!";
$PMF_LANG["msgMailContact"] = "Jūsų pranešimas buvo išsiųstas administratoriui.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Nėra ryšio su duomenų baze.";
$PMF_LANG["err_noHeaders"] = "Nerasta grupė.";
$PMF_LANG["err_noArticles"] = "Nėra prieinamų DUK.";
$PMF_LANG["err_badID"] = "Blogas identifikatorius.";
$PMF_LANG["err_noTopTen"] = "Populiariausi DUK kol kas neprieinami.";
$PMF_LANG["err_nothingFound"] = "Įrašų nerasta.";
$PMF_LANG["err_SaveEntries"] = "Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>grupė</strong>, <strong>antraštė</strong>, <strong>jūsų įrašas</strong> ir, kai prašoma, <strong><a href=\"http://lt.wikipedia.org/wiki/CAPTCHA\" title=\"Sužinokite daugiau apie CAPTCHA Vikipedijoje\" target=\"_blank\">CAPTCHA</a> kodas</strong>!<br><br><a href=\"javascript:history.back();\">į ankstesnį tinklalapį</a><br><br>";
$PMF_LANG["err_SaveComment"] = "Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>jūsų komentarai</strong> ir, kai prašoma, <strong><a href=\"http://lt.wikipedia.org/wiki/CAPTCHA\" title=\"Sužinokite daugiau apie CAPTCHA Vikipedijoje\" target=\"_blank\">CAPTCHA</a> kodas</strong>!<br><br><a href=\"javascript:history.back();\">į ankstesnį tinklalapį</a><br><br>";
$PMF_LANG["err_VoteTooMuch"] = "Mes neskaičiuojame dvigubų balsų. Į ankstesnį tinklalapį.";
$PMF_LANG["err_noVote"] = "<strong>Jūs neįvertinote klausimo!</strong> Norėdami balsuoti <a href=\"javascript:history.back();\">spauskite čia</a>.";
$PMF_LANG["err_noMailAdress"] = "Jūsų el. pašto adresas yra neteisingas.<br><a href=\"javascript:history.back();\">atgal</a>";
$PMF_LANG["err_sendMail"] = "Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>jūsų klausimas</strong> ir, kai prašoma, <strong><a href=\"http://lt.wikipedia.org/wiki/CAPTCHA\" title=\"Sužinokite daugiau apie CAPTCHA Vikipedijoje\" target=\"_blank\">CAPTCHA</a> kodas</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Ieškoti įrašų:</strong><br>Su tokia paieška <strong style=\"color: Red;\">žodis1 žodis2</strong> jūs galite ieškoti svarbumo mažėjimo tvarka pagal du ar daugiau paieškos kriterijų.<strong>Pastaba:</strong> Jūsų paieškos kriterijus turi būti bent 4 raidžių ilgio, kitu atveju užklausa bus atmesta.";

// Men�
$PMF_LANG["ad"] = "ADMINISTRAVIMO SEKCIJA";
$PMF_LANG["ad_menu_user_administration"] = "Naudotojai";
$PMF_LANG["ad_menu_entry_aprove"] = "Patvirtinti DUK";
$PMF_LANG["ad_menu_entry_edit"] = "Redaguoti DUK";
$PMF_LANG["ad_menu_categ_add"] = "Pridėti grupę";
$PMF_LANG["ad_menu_categ_edit"] = "Redaguoti grupę";
$PMF_LANG["ad_menu_news_add"] = "Pridėti naujieną";
$PMF_LANG["ad_menu_news_edit"] = "Redaguoti naujienas";
$PMF_LANG["ad_menu_open"] = "Atviri klausimai";
$PMF_LANG["ad_menu_stat"] = "Statistika";
$PMF_LANG["ad_menu_cookie"] = "Nustatyti slapukus";
$PMF_LANG["ad_menu_session"] = "Peržiūrėti seansus";
$PMF_LANG["ad_menu_adminlog"] = "Peržiūrėti administravimo žurnalą";
$PMF_LANG["ad_menu_passwd"] = "Keisti slaptažodį";
$PMF_LANG["ad_menu_logout"] = "Atsijungti";
$PMF_LANG["ad_menu_startpage"] = "Pradžios tinklalapis";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Prašome save identifikuoti.";
$PMF_LANG["ad_msg_passmatch"] = "Abu slaptažodžiai turi <strong>sutapti</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "";
$PMF_LANG["ad_msg_savedsuc_2"] = "profilis sėkmingai išsaugotas.";
$PMF_LANG["ad_msg_mysqlerr"] = "Dėl <strong>duomenų bazės klaidos</strong> nepavyko išsaugoti profilio.";
$PMF_LANG["ad_msg_noauth"] = "Jūsų prieiga neleidžiama.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Puslapis";
$PMF_LANG["ad_gen_of"] = "iš";
$PMF_LANG["ad_gen_lastpage"] = "Ankstesnis puslapis";
$PMF_LANG["ad_gen_nextpage"] = "Kitas puslapis";
$PMF_LANG["ad_gen_save"] = "Išsaugoti";
$PMF_LANG["ad_gen_reset"] = "Atkurti";
$PMF_LANG["ad_gen_yes"] = "Taip";
$PMF_LANG["ad_gen_no"] = "Ne";
$PMF_LANG["ad_gen_top"] = "Tinklalapio viršus";
$PMF_LANG["ad_gen_ncf"] = "Grupė nerasta!";
$PMF_LANG["ad_gen_delete"] = "Šalinti";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Naudotojų administravimas";
$PMF_LANG["ad_user_username"] = "Registruoti naudotojai";
$PMF_LANG["ad_user_rights"] = "Naudotojų teisės";
$PMF_LANG["ad_user_edit"] = "redaguoti";
$PMF_LANG["ad_user_delete"] = "šalinti";
$PMF_LANG["ad_user_add"] = "Pridėti naudotoją";
$PMF_LANG["ad_user_profou"] = "Naudotojo profilis";
$PMF_LANG["ad_user_name"] = "Vardas";
$PMF_LANG["ad_user_password"] = "Slaptažodis";
$PMF_LANG["ad_user_confirm"] = "Patvirtinti";
$PMF_LANG["ad_user_rights"] = "Teisės";
$PMF_LANG["ad_user_del_1"] = "Naudotojas";
$PMF_LANG["ad_user_del_2"] = "bus pašalintas?";
$PMF_LANG["ad_user_del_3"] = "Ar tikrai to norite?";
$PMF_LANG["ad_user_deleted"] = "Naudotojas sėkmingai pašalintas.";
$PMF_LANG["ad_user_checkall"] = "Pažymėti viską";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "Įrašų administravimas";
$PMF_LANG["ad_entry_id"] = "Identifikatorius";
$PMF_LANG["ad_entry_topic"] = "Tema";
$PMF_LANG["ad_entry_action"] = "Veiksmas";
$PMF_LANG["ad_entry_edit_1"] = "Redaguoti įrašą";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Klausimas";
$PMF_LANG["ad_entry_content"] = "Atsakymas";
$PMF_LANG["ad_entry_keywords"] = "Raktažodžiai";
$PMF_LANG["ad_entry_author"] = "Autorius";
$PMF_LANG["ad_entry_category"] = "Grupė";
$PMF_LANG["ad_entry_active"] = "Aktyvus?";
$PMF_LANG["ad_entry_date"] = "Data";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "Pakeistas?";
$PMF_LANG["ad_entry_changelog"] = "Keitimų žurnalas";
$PMF_LANG["ad_entry_commentby"] = "Komentavo";
$PMF_LANG["ad_entry_comment"] = "Komentarai";
$PMF_LANG["ad_entry_save"] = "Išsaugoti";
$PMF_LANG["ad_entry_delete"] = "šalinti";
$PMF_LANG["ad_entry_delcom_1"] = "Ar tikrai norite pašalinti naudotojo";
$PMF_LANG["ad_entry_delcom_2"] = "komentarą?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Komentaras buvo <strong>sėkmingai</strong> pašalintas.";
$PMF_LANG["ad_entry_back"] = "Atgal į straipsnį";
$PMF_LANG["ad_entry_commentdelfail"] = "Komentaras <strong>nebuvo</strong> pašalintas.";
$PMF_LANG["ad_entry_savedsuc"] = "Pakeitimai <strong>sėkmingai</strong> išsaugoti.";
$PMF_LANG["ad_entry_savedfail"] = "Deja, įvyko <strong>duomenų bazės klaida</strong>.";
$PMF_LANG["ad_entry_del_1"] = "Ar tikrai norite pašalinti temą";
$PMF_LANG["ad_entry_del_2"] = "iš";
$PMF_LANG["ad_entry_del_3"] = "?";
$PMF_LANG["ad_entry_delsuc"] = "Objektas <strong>sėkmingai</strong> pašalintas.";
$PMF_LANG["ad_entry_delfail"] = "Objektas <strong>nepašalintas</strong>!";
$PMF_LANG["ad_entry_back"] = "Atgal";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Naujienos antraštė";
$PMF_LANG["ad_news_text"] = "Įrašo tekstas";
$PMF_LANG["ad_news_link_url"] = "Saitas (<strong>be http://</strong>)";
$PMF_LANG["ad_news_link_title"] = "Saito pavadinimas";
$PMF_LANG["ad_news_link_target"] = "Saito paskirtis";
$PMF_LANG["ad_news_link_window"] = "Saitas atveria naują langą";
$PMF_LANG["ad_news_link_faq"] = "Saitas DUK viduje";
$PMF_LANG["ad_news_add"] = "Pridėti naujiną";
$PMF_LANG["ad_news_id"] = "nr.";
$PMF_LANG["ad_news_headline"] = "Antraštė";
$PMF_LANG["ad_news_date"] = "Data";
$PMF_LANG["ad_news_action"] = "Veiksmas";
$PMF_LANG["ad_news_update"] = "atnaujinti";
$PMF_LANG["ad_news_delete"] = "šalinti";
$PMF_LANG["ad_news_nodata"] = "Duomenų bazėje nerasta duomenų";
$PMF_LANG["ad_news_updatesuc"] = "Naujiena buvo atnaujinta.";
$PMF_LANG["ad_news_del"] = "Ar tikrai norite pašalinti šį naujienų elementą?";
$PMF_LANG["ad_news_yesdelete"] = "taip, šalinti!";
$PMF_LANG["ad_news_nodelete"] = "ne!";
$PMF_LANG["ad_news_delsuc"] = "Naujienų elementas pašalintas.";
$PMF_LANG["ad_news_updatenews"] = "Naujienų elementas atnaujintas.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Pridėti naują grupę";
$PMF_LANG["ad_categ_catnum"] = "Grupės numeris";
$PMF_LANG["ad_categ_subcatnum"] = "Pogrupio numeris";
$PMF_LANG["ad_categ_nya"] = "<em>dar neprieinama!</em>";
$PMF_LANG["ad_categ_titel"] = "Grupės pavadinimas";
$PMF_LANG["ad_categ_add"] = "Pridėti grupę";
$PMF_LANG["ad_categ_existing"] = "Egzistuojančios grupės";
$PMF_LANG["ad_categ_id"] = "nr.";
$PMF_LANG["ad_categ_categ"] = "Grupė";
$PMF_LANG["ad_categ_subcateg"] = "Pogrupis";
$PMF_LANG["ad_categ_titel"] = "Grupės pavadinimas";
$PMF_LANG["ad_categ_action"] = "Veiksmas";
$PMF_LANG["ad_categ_update"] = "atnaujinti";
$PMF_LANG["ad_categ_delete"] = "šalinti";
$PMF_LANG["ad_categ_updatecateg"] = "Atnaujinti grupę";
$PMF_LANG["ad_categ_nodata"] = "Duomenų bazėje nerasta duomenų";
$PMF_LANG["ad_categ_remark"] = "Pastebėkite, kad egzistuojantys įrašai bus daugiau nebematomi, jei pašalinsite grupę. Jūs privalote priskirti naują grupę straipsniui arba pašalinti straipsnį.";
$PMF_LANG["ad_categ_edit_1"] = "Redaguoti";
$PMF_LANG["ad_categ_edit_2"] = "Grupė";
$PMF_LANG["ad_categ_add"] = "pridėti grupę";
$PMF_LANG["ad_categ_added"] = "Grupė pridėta.";
$PMF_LANG["ad_categ_updated"] = "Grupė atnaujinta.";
$PMF_LANG["ad_categ_del_yes"] = "taip, šalinti!";
$PMF_LANG["ad_categ_del_no"] = "ne!";
$PMF_LANG["ad_categ_deletesure"] = "Ar tikrai norite pašalinti šią grupę?";
$PMF_LANG["ad_categ_deleted"] = "Grupė pašalinta.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Slapukas <strong>sėkmingai</strong> nustatytas.";
$PMF_LANG["ad_cookie_already"] = "Slapukas jau buvo nustatytas. Jūs dabar turite tokias parinktis";
$PMF_LANG["ad_cookie_again"] = "Nustatyti slapuką iš naujo";
$PMF_LANG["ad_cookie_delete"] = "Pašalinti slapuką";
$PMF_LANG["ad_cookie_no"] = "Slapukas dar nėra išsaugotas. Su slapuku jūs galite išsaugoti savo prisijungimo duomenis, tokiu būdu jums nebereikės prisiminti savo prisijungimo duomenų. Jūs dabar turite tokias parinktis";
$PMF_LANG["ad_cookie_set"] = "Nustatyti slapuką";
$PMF_LANG["ad_cookie_deleted"] = "Slapukas sėkmingai pašalintas.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Administravimo žurnalas";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Pakeisti savo slaptažodį";
$PMF_LANG["ad_passwd_old"] = "Senas slaptažodis";
$PMF_LANG["ad_passwd_new"] = "Naujas slaptažodis";
$PMF_LANG["ad_passwd_con"] = "Patvirtinti";
$PMF_LANG["ad_passwd_change"] = "Keisti slaptažodį";
$PMF_LANG["ad_passwd_suc"] = "Slaptažodis sėkmingai pakeistas.";
$PMF_LANG["ad_passwd_remark"] = "<strong>DĖMESIO:</strong><br>Slapukas turi būti nustatytas iš naujo!";
$PMF_LANG["ad_passwd_fail"] = "Senas slaptažodis <strong>privalo</strong> būti teisingai įvestas, o abu nauji turi <strong>sutapti</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Pridėti naudotoją";
$PMF_LANG["ad_adus_name"] = "Vardas";
$PMF_LANG["ad_adus_password"] = "Slaptažodis";
$PMF_LANG["ad_adus_add"] = "Pridėti naudotoją";
$PMF_LANG["ad_adus_suc"] = "Naudotojas <strong>sėkmingai</strong> pridėtas.";
$PMF_LANG["ad_adus_edit"] = "Redaguoti profilį";
$PMF_LANG["ad_adus_dberr"] = "<strong>duomenų bazės klaida!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Naudotojo vardas jau <strong>egzistuoja</strong>.";

// Sessions
$PMF_LANG["ad_sess_id"] = "Identifikatorius";
$PMF_LANG["ad_sess_sid"] = "Seanso identifikatorius";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Laikas";
$PMF_LANG["ad_sess_pageviews"] = "Tinklalapio peržiūros";
$PMF_LANG["ad_sess_search"] = "Paieška";
$PMF_LANG["ad_sess_sfs"] = "Ieškoti seansų";
$PMF_LANG["ad_sess_s_ip"] = "IP adresas";
$PMF_LANG["ad_sess_s_minct"] = "min. veiksmai";
$PMF_LANG["ad_sess_s_date"] = "Data";
$PMF_LANG["ad_sess_s_after"] = "po";
$PMF_LANG["ad_sess_s_before"] = "prieš";
$PMF_LANG["ad_sess_s_search"] = "Ieškoti";
$PMF_LANG["ad_sess_session"] = "Seansas";
$PMF_LANG["ad_sess_r"] = "Paieškos rezultatai";
$PMF_LANG["ad_sess_referer"] = "Referalai";
$PMF_LANG["ad_sess_browser"] = "Naršyklė";
$PMF_LANG["ad_sess_ai_rubrik"] = "Grupė";
$PMF_LANG["ad_sess_ai_artikel"] = "Įrašas";
$PMF_LANG["ad_sess_ai_sb"] = "Paieškos eilutės";
$PMF_LANG["ad_sess_ai_sid"] = "Seanso identifikatorius";
$PMF_LANG["ad_sess_back"] = "Atgal";

// Statistik
$PMF_LANG["ad_rs"] = "Įverčių statistika";
$PMF_LANG["ad_rs_rating_1"] = "Įverčiai iš";
$PMF_LANG["ad_rs_rating_2"] = "naudotojų rodo";
$PMF_LANG["ad_rs_red"] = "Raudona";
$PMF_LANG["ad_rs_green"] = "Žalia";
$PMF_LANG["ad_rs_altt"] = "vidurkis mažesnis už 20%";
$PMF_LANG["ad_rs_ahtf"] = "vidurkis didesnis už 80%";
$PMF_LANG["ad_rs_no"] = "Nėra įverčių";

// Auth
$PMF_LANG["ad_auth_insert"] = "Prašome įvesti savo naudotojo vardą ir slaptažodį.";
$PMF_LANG["ad_auth_user"] = "Naudotojo vardas";
$PMF_LANG["ad_auth_passwd"] = "Slaptažodis";
$PMF_LANG["ad_auth_ok"] = "Gerai";
$PMF_LANG["ad_auth_reset"] = "Atkurti";
$PMF_LANG["ad_auth_fail"] = "Naudotojas arba slaptažodis neteisingas.";
$PMF_LANG["ad_auth_sess"] = "Perduotas seanso identifikatorius.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Redaguoti konfigūraciją";
$PMF_LANG["ad_config_save"] = "Išsaugoti konfigūraciją";
$PMF_LANG["ad_config_reset"] = "Atkurti";
$PMF_LANG["ad_config_saved"] = "Konfigūracija sėkmingai išsaugota.";
$PMF_LANG["ad_menu_editconfig"] = "Redaguoti konfigūraciją";
$PMF_LANG["ad_att_none"] = "Nėra priedų";
$PMF_LANG["ad_att_att"] = "Priedai";
$PMF_LANG["ad_att_add"] = "Pridėti failą";
$PMF_LANG["ad_entryins_suc"] = "Įrašas sėkmingai išsaugotas.";
$PMF_LANG["ad_entryins_fail"] = "Įvyko klaida.";
$PMF_LANG["ad_att_del"] = "Šalinti";
$PMF_LANG["ad_att_nope"] = "Priedai gali būti pridėti tik kai redaguojama.";
$PMF_LANG["ad_att_delsuc"] = "Priedas sėkmingai pašalintas.";
$PMF_LANG["ad_att_delfail"] = "Įvyko klaida šalinant priedą.";
$PMF_LANG["ad_entry_add"] = "Pridėti DUK";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Atsarginė kopija yra pilnas duomenų bazės turinio atvaizdis. Atsarginės kopijos formatas yra SQL tranzakcijos failas, kuris gali būti importuotas naudojant tokius įrankius kaip phpMyAdmin ar komandos eilutės SQL klientas. Atsarginė kopija turėtų būti daroma bent kartą per mėnesį.";
$PMF_LANG["ad_csv_link"] = "Atsiųsti atsarginę kopiją";
$PMF_LANG["ad_csv_head"] = "Sukurti atsarginę kopiją";
$PMF_LANG["ad_att_addto"] = "Pridėti priedą prie objekto";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Failas";
$PMF_LANG["ad_att_butt"] = "Gerai";
$PMF_LANG["ad_att_suc"] = "Failas pridėtas sėkmingai.";
$PMF_LANG["ad_att_fail"] = "Įvyko klaida pridedant failą.";
$PMF_LANG["ad_att_close"] = "Užverti šį langą";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Su šia forma jūs galite atkurti duomenų bazės turinį, naudodami atsarginę kopiją sukurtą su phpMyFAQ. Pastebėkite, kad dabartiniai duomenys bus perrašyti.";
$PMF_LANG["ad_csv_file"] = "Failas";
$PMF_LANG["ad_csv_ok"] = "Gerai";
$PMF_LANG["ad_csv_linklog"] = "žurnalo atsarginė kopija";
$PMF_LANG["ad_csv_linkdat"] = "duomenų atsarginė kopija";
$PMF_LANG["ad_csv_head2"] = "Atkurti";
$PMF_LANG["ad_csv_no"] = "Nepanašu, kad čia phpMyFAQ atsarginė kopija.";
$PMF_LANG["ad_csv_prepare"] = "Ruošiamos duomenų bazės užklausos...";
$PMF_LANG["ad_csv_process"] = "Vykdomos užklausos...";
$PMF_LANG["ad_csv_of"] = "iš";
$PMF_LANG["ad_csv_suc"] = "buvo sėkmingos.";
$PMF_LANG["ad_csv_backup"] = "Atsarginė kopija";
$PMF_LANG["ad_csv_rest"] = "Atkurti iš atsarginės kopijos";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Atsarginė kopija";
$PMF_LANG["ad_logout"] = "Seansas sėkmingai nutrauktas.";
$PMF_LANG["ad_news_add"] = "Pridėti naujieną";
$PMF_LANG["ad_news_edit"] = "Redaguoti naujieną";
$PMF_LANG["ad_cookie"] = "Slapukai";
$PMF_LANG["ad_sess_head"] = "Peržiūrėti seansus";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "Grupės";
$PMF_LANG["ad_menu_stat"] = "Įverčių statistika";
$PMF_LANG["ad_kateg_add"] = "pridėti pagrindinę grupę";
$PMF_LANG["ad_kateg_rename"] = "Pervadinti";
$PMF_LANG["ad_adminlog_date"] = "Data";
$PMF_LANG["ad_adminlog_user"] = "Naudotojas";
$PMF_LANG["ad_adminlog_ip"] = "IP adresas";

$PMF_LANG["ad_stat_sess"] = "Seansai";
$PMF_LANG["ad_stat_days"] = "Dienos";
$PMF_LANG["ad_stat_vis"] = "Seansai (apsilankymai)";
$PMF_LANG["ad_stat_vpd"] = "Apsilankymų per dieną";
$PMF_LANG["ad_stat_fien"] = "Pirmas įrašas";
$PMF_LANG["ad_stat_laen"] = "Paskutinis įrašas";
$PMF_LANG["ad_stat_browse"] = "Naršyti seansus";
$PMF_LANG["ad_stat_ok"] = "Gerai";

$PMF_LANG["ad_sess_time"] = "Laikas";
$PMF_LANG["ad_sess_sid"] = "Seanso identifikatorius";
$PMF_LANG["ad_sess_ip"] = "IP adresas";

$PMF_LANG["ad_ques_take"] = "Imtis klausimo ir redaguoti";
$PMF_LANG["no_cats"] = "Nerasta grupė";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Neteisingas naudotojo vardas ar slaptažodis.";
$PMF_LANG["ad_log_sess"] = "Seansas nebegalioja.";
$PMF_LANG["ad_log_edit"] = "„Redaguoti naudotoją“ forma šiam naudotojui: ";
$PMF_LANG["ad_log_crea"] = "Forma „Naujas straipsnis“.";
$PMF_LANG["ad_log_crsa"] = "Sukurtas naujas įrašas.";
$PMF_LANG["ad_log_ussa"] = "Atnaujinti duomenis šiems naudotojams: ";
$PMF_LANG["ad_log_usde"] = "Pašalinti šie naudotojai: ";
$PMF_LANG["ad_log_beed"] = "Redagavimo forma šiems naudotojams: ";
$PMF_LANG["ad_log_bede"] = "Pašalintas šis įrašas: ";

$PMF_LANG["ad_start_visits"] = "Apsilankymai";
$PMF_LANG["ad_start_articles"] = "Straipsniai";
$PMF_LANG["ad_start_comments"] = "Komentarai";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "įdėti";
$PMF_LANG["ad_categ_cut"] = "iškirpti";
$PMF_LANG["ad_categ_copy"] = "kopijuoti";
$PMF_LANG["ad_categ_process"] = "Apdorojamos grupės...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Jūs nesate sankcionuotas.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "ankstesnis tinklalapis";
$PMF_LANG["msgNextPage"] = "tolesnis tinklalapis";
$PMF_LANG["msgPageDoublePoint"] = "Tinklalapis: ";
$PMF_LANG["msgMainCategory"] = "Pagrindinė grupė";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Jūsų slaptažodis pakeistas.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "Rodyti kaip PDF failą";
$PMF_LANG["ad_xml_head"] = "XML atsarginė kopija";
$PMF_LANG["ad_xml_hint"] = "Išsaugoti visus jūsų DUK įrašus viename XML faile.";
$PMF_LANG["ad_xml_gen"] = "sukurti XML failą";
$PMF_LANG["ad_entry_locale"] = "Kalba";
$PMF_LANG["msgLanguageSubmit"] = "Parinkti kalbą";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Peržiūra";
$PMF_LANG["ad_attach_1"] = "Prašau iš pradžių parinkti priedų katalogą konfigūracijoje.";
$PMF_LANG["ad_attach_2"] = "Prašau iš pradžių parinkti nuorodą priedams konfigūracijoje.";
$PMF_LANG["ad_attach_3"] = "Failas „attachment.php“ negali būti atvertas be tinkamo tapatumo nustatymo.";
$PMF_LANG["ad_attach_4"] = "Pridedamas failas turi būti ne didesnis nei %s baitų.";
$PMF_LANG["ad_menu_export"] = "Eksportuoti jūsų DUK";
$PMF_LANG["ad_export_1"] = "Sukurtas sklaidos kanalas";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "Klaida: Nepavyko įrašyti failo.";
$PMF_LANG["ad_export_news"] = "Naujienų sklaidos kanalas";
$PMF_LANG["ad_export_topten"] = "10 pirmųjų sklaidos kanalas";
$PMF_LANG["ad_export_latest"] = "5 paskutinių įrašų sklaidos kanalas";
$PMF_LANG["ad_export_pdf"] = "Visų įrašų PDF eksportas";
$PMF_LANG["ad_export_generate"] = "sukurti sklaidos kanalą";

$PMF_LANG["rightsLanguage"]['add_user'] = "pridėti naudotoją";
$PMF_LANG["rightsLanguage"]['edit_user'] = "redaguoti naudotoją";
$PMF_LANG["rightsLanguage"]['delete_user'] = "šalinti naudotoją";
$PMF_LANG["rightsLanguage"]['add_faq'] = "pridėti įrašą";
$PMF_LANG["rightsLanguage"]['edit_faq'] = "redaguoti įrašą";
$PMF_LANG["rightsLanguage"]['delete_faq'] = "šalinti įrašą";
$PMF_LANG["rightsLanguage"]['viewlog'] = "peržiūrėti žurnalą";
$PMF_LANG["rightsLanguage"]['adminlog'] = "peržiūrėti administravimo žurnalą";
$PMF_LANG["rightsLanguage"]['delcomment'] = "šalinti komentarą";
$PMF_LANG["rightsLanguage"]['addnews'] = "pridėti naujieną";
$PMF_LANG["rightsLanguage"]['editnews'] = "redaguoti naujieną";
$PMF_LANG["rightsLanguage"]['delnews'] = "šalinti naujieną";
$PMF_LANG["rightsLanguage"]['addcateg'] = "pridėti grupę";
$PMF_LANG["rightsLanguage"]['editcateg'] = "redaguoti grupę";
$PMF_LANG["rightsLanguage"]['delcateg'] = "šalinti grupę";
$PMF_LANG["rightsLanguage"]['passwd'] = "keisti slaptažodį";
$PMF_LANG["rightsLanguage"]['editconfig'] = "redaguoti konfigūraciją";
$PMF_LANG["rightsLanguage"]['addatt'] = "pridėti priedą";
$PMF_LANG["rightsLanguage"]['delatt'] = "šalinti priedą";
$PMF_LANG["rightsLanguage"]['backup'] = "sukurti atsarginę kopiją";
$PMF_LANG["rightsLanguage"]['restore'] = "atkurti iš atsarginės kopijos";
$PMF_LANG["rightsLanguage"]['delquestion'] = "šalinti atvirus klausimus";
$PMF_LANG["rightsLanguage"]['changebtrevs'] = "redaguoti pataisas";

$PMF_LANG["msgAttachedFiles"] = "pridėti failai";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "veiksmas";
$PMF_LANG["ad_entry_email"] = "El. pašto adresas";
$PMF_LANG["ad_entry_allowComments"] = "Leisti komentarus";
$PMF_LANG["msgWriteNoComment"] = "Jūs negalite komentuoti šio įrašo";
$PMF_LANG["ad_user_realname"] = "tikras vardas";
$PMF_LANG["ad_export_generate_pdf"] = "generuoti PDF failą";
$PMF_LANG["ad_export_full_faq"] = "Jūsų DUK kaip PDF failas: ";
$PMF_LANG["err_bannedIP"] = "Jūsų IP adresas buvo uždraustas.";
$PMF_LANG["err_SaveQuestion"] = "Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>jūsų klausimas</strong> ir, kai prašoma, <strong><a href=\"http://lt.wikipedia.org/wiki/CAPTCHA\" title=\"Sužinokite daugiau apie CAPTCHA Vikipedijoje\" target=\"_blank\">CAPTCHA</a> kodas</strong>!<br><br><a href=\"javascript:history.back();\">į ankstesnį tinklalapį</a><br><br>";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Šrifto spalva: ";
$PMF_LANG["ad_entry_fontsize"] = "Šrifto dydis: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "Kalbos failas");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Įjungti automatinį turinio atpažinimą");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "DUK antraštė");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "DUK versija");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Tinklalapio aprašas");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Raktažodžiai paieškos serveriams");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Leidėjo pavadinimas");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "Administratoriaus el. pašto adresas");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "Kontaktinė informacija");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Tekstas tinklalapiui „siųsti draugui“");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "Maksimalus priedo dydis baitais (maks. %sB)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Rodyti priedų nuorodas po įrašais?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "Naudoti sekimą?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "Naudoti administravimo žurnalą?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "Ar norite, kad būtų tikrinamas IP, kai tikrinami UIN tinklalapyje „admin.php“?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Puslapyje rodomų temų skaičius");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Naujienų straipsnių skaičius");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "Drausti šiuos IP adresus");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "Aktyvinti „mod_rewrite“ palaikymą? (numatyta r.: išjungta)");
$LANG_CONF["ldap.ldapSupport"] = array(0 => "checkbox", 1 => "Ar įjungti LDAP palaikymą? (numatyta r.: išjungta)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "Bazinis URL saitų tikrinimui (pvz., http://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "Intervalas tarp AJAX saitų tikrinimo (sekundėmis)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "Išjungti naujų klausimų matomumą?");
$LANG_CONF['security.permLevel'] = array(0 => "select", 1 => "Leidimų lygis");

$PMF_LANG["ad_categ_new_main_cat"] = "kaip naują pagrindinę grupę";
$PMF_LANG["ad_categ_paste_error"] = "Šios grupės perkelti neįmanoma.";
$PMF_LANG["ad_categ_move"] = "perkelti grupę";
$PMF_LANG["ad_categ_lang"] = "Kalba";
$PMF_LANG["ad_categ_desc"] = "Aprašas";
$PMF_LANG["ad_categ_change"] = "Sukeisti su";

$PMF_LANG["lostPassword"] = "Užmiršote slaptažodį? Spauskite čia.";
$PMF_LANG["lostpwd_err_1"] = "Klaida: Naudotojo vardas ir el. pašto adresas nerasti.";
$PMF_LANG["lostpwd_err_2"] = "Klaida: Neteisingi įrašai!";
$PMF_LANG["lostpwd_text_1"] = "Ačiū, kad paprašėte savo paskyros informacijos.";
$PMF_LANG["lostpwd_text_2"] = "Prašome nustatyti naują asmeninį slaptažodį DUK administravimo sekcijoje.";
$PMF_LANG["lostpwd_mail_okay"] = "El. laiškas išsiųstas.";

$PMF_LANG["ad_xmlrpc_button"] = "Gauti naujausios phpMyFAQ versijos numerį per žiniatinklio tarnybą";
$PMF_LANG["ad_xmlrpc_latest"] = "Naujausia versija prieinama";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Išrinkite grupės kalbą';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Svetainės struktūra';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Šis įrašas yra pataisytas ir negali būti parodytas.';
$PMF_LANG['msgArticleCategories'] = 'Grupės šiam įrašui';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'Unikalus sprendimo identifikatorius';
$PMF_LANG['ad_entry_faq_record'] = 'DUK įrašas';
$PMF_LANG['ad_entry_new_revision'] = 'Sukurti naują pataisą?';
$PMF_LANG['ad_entry_record_administration'] = 'Įrašų administravimas';
$PMF_LANG['ad_entry_changelog'] = 'Keitimų žurnalas';
$PMF_LANG['ad_entry_revision'] = 'Pataisa';
$PMF_LANG['ad_changerev'] = 'Išrinkite pataisą';
$PMF_LANG['msgCaptcha'] = "Prašome įvesti simbolius, kuriuos matote paveiksle";
$PMF_LANG['msgSelectCategories'] = 'Ieškoti ...';
$PMF_LANG['msgAllCategories'] = '... visose grupėse';
$PMF_LANG['ad_you_should_update'] = 'Jūsų phpMyFAQ įdiegimas yra pasenęs. Jūs turėtumėte jį atnaujinti iki naujausios prieinamos versijos.';
$PMF_LANG['msgAdvancedSearch'] = 'Patikslintoji paieška';

// added v1.6.1 - 2006-04-25 by Matteo�and�Thorsten
$PMF_LANG['spamControlCenter'] = 'Brukalo kontrolės centras';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "Spausdinti naudotojų el. laiškus saugiu būdu (numatyta r.: įjungta).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "Tikrinti viešų formų turinį pagal draudžiamų žodžių sąrašą (numatyta r.: įjungta).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "Naudoti CAPTCHA kodus viešam formų pateikimui (numatyta r.: įjungta).");
$PMF_LANG['ad_session_expiring'] = 'Jūsų seansas baigs galioti po %d minučių: ar norėtumėte tęsti darbą?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Seansų tvarkymas';
$PMF_LANG['ad_stat_choose'] = 'Pasirinkite mėnesį';
$PMF_LANG['ad_stat_delete'] = 'Nedelsiant pašalinti išrinktus seansus';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Specialių terminų žodynas';
$PMF_LANG['ad_glossary_add'] = 'Pridėti specialių terminų žodyno įrašą';
$PMF_LANG['ad_glossary_edit'] = 'Redaguoti specialių terminų žodyno įrašą';
$PMF_LANG['ad_glossary_item'] = 'Terminas';
$PMF_LANG['ad_glossary_definition'] = 'Aprašas';
$PMF_LANG['ad_glossary_save'] = 'Išsaugoti įrašą';
$PMF_LANG['ad_glossary_save_success'] = 'Specialių terminų žodyno įrašas sėkmingai išsaugotas!';
$PMF_LANG['ad_glossary_save_error'] = 'Nepavyko išsaugoti specialių terminų žodyno įrašo, nes įvyko klaida.';
$PMF_LANG['ad_glossary_update_success'] = 'Specialių terminų žodyno įrašas sėkmingai atnaujintas!';
$PMF_LANG['ad_glossary_update_error'] = 'Nepavyko atnaujinti specialių terminų žodyno įrašo, nes įvyko klaida.';
$PMF_LANG['ad_glossary_delete'] = 'Pašalinti įrašą';
$PMF_LANG['ad_glossary_delete_success'] = 'Specialių terminų žodyno įrašas sėkmingai pašalintas!';
$PMF_LANG['ad_glossary_delete_error'] = 'Nepavyko pašalinti specialių terminų žodyno įrašo, nes įvyko klaida.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Automatinis saitų tikrinimas išjungtas (bazinis URL saitų tikrinimui nenustatytas)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Automatinis saitų tikrinimas išjungtas (PHP parametras „allow_url_fopen“ neįjungtas)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'Automatinio saitų tikrinimo rezultatas';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'Gerai';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Nesėkmė';
$PMF_LANG['ad_linkcheck_failReason'] = 'Nesėkmės priežastys:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Nerastas URL suderintas su saitų tikrinimo funkcija.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Tik su blogais saitais';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Papildoma informacija:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'Rasta testuojant <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'Saitų tikrintuvė neparuošta.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Viršytas didžiausias peradresavimų skaičius (<strong>%d</strong>).';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'Nustatyta į tuščią URL.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'Serveris <strong>%s</strong> yra lėtas arba neatsako.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'DNS susiejimas serveriui <strong>%s</strong> yra lėtas ar nepavyko dėl DNS problemų, vietinių ar nutolusių.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL buvo nukreiptas į <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'Nevienareikšmė HTTP būsena <strong>%s</strong> grąžinta.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = '<em>HEAD</em> metodas yra nepalaikomas serverio <strong>%s</strong>, leidžiami metodai: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'Šis išteklius negali būti rastas serveryje <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s protokolas nepalaikomas automatinio saitų tikrintuvės.';
$PMF_LANG['msgNewQuestionVisible'] = 'Klausimas turi būti peržiūrėtas prieš pateikiamas viešai.';
$PMF_LANG['msgQuestionsWaiting'] = 'Laukiama administratorių publikavimo: ';
$PMF_LANG['ad_entry_visibility'] = 'Publikuoti';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] = "Prašome įvesti slaptažodį. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "Slaptažodžiai nesutampa. ";
$PMF_LANG['ad_user_error_loginInvalid'] = "Nurodytas naudotojo vardas neteisingas.";
$PMF_LANG['ad_user_error_noEmail'] = "Įveskite teisingą el. pašto adresą. ";
$PMF_LANG['ad_user_error_noRealName'] = "Prašome įvesti savo tikrą vardą. ";
$PMF_LANG['ad_user_error_delete'] = "Naudotojų paskyros nepašalintos. ";
$PMF_LANG['ad_user_error_noId'] = "Nenurodytas identifikatorius. ";
$PMF_LANG['ad_user_error_protectedAccount'] = "Naudotojo paskyra apsaugota. ";
$PMF_LANG['ad_user_deleteUser'] = "Šalinti naudotoją";
$PMF_LANG['ad_user_status'] = "Būsena";
$PMF_LANG['ad_user_lastModified'] = "paskutinių keitimų data";
$PMF_LANG['ad_gen_cancel'] = "Atsisakyti";
$PMF_LANG["rightsLanguage"]['addglossary'] = "pridėti specialių terminų žodyno įrašą";
$PMF_LANG["rightsLanguage"]['editglossary'] = "redaguoti specialių terminų žodyno įrašą";
$PMF_LANG["rightsLanguage"]['delglossary'] = "šalinti specialių terminų žodyno įrašą";
$PMF_LANG["ad_menu_group_administration"] = "Naudotojų grupės";
$PMF_LANG['ad_user_loggedin'] = 'Prisijungęs kaip ';

$PMF_LANG['ad_group_details'] = "Išsami grupės informacija";
$PMF_LANG['ad_group_add'] = "Pridėti grupę";
$PMF_LANG['ad_group_add_link'] = "Pridėti grupę";
$PMF_LANG['ad_group_name'] = "Pavadinimas";
$PMF_LANG['ad_group_description'] = "Aprašas";
$PMF_LANG['ad_group_autoJoin'] = "Automatiškai prijungti";
$PMF_LANG['ad_group_suc'] = "Grupė <strong>sėkmingai</strong> pridėta.";
$PMF_LANG['ad_group_error_noName'] = "Įveskite grupės pavadinimą. ";
$PMF_LANG['ad_group_error_delete'] = "Nepavyko pašalinti grupės. ";
$PMF_LANG['ad_group_deleted'] = "Grupė sėkmingai pašalinta.";
$PMF_LANG['ad_group_deleteGroup'] = "Šalinti grupę";
$PMF_LANG['ad_group_deleteQuestion'] = "Ar tikrai norite pašalinti šią grupę?";
$PMF_LANG['ad_user_uncheckall'] = "Panaikinti žymėjimą";
$PMF_LANG['ad_group_membership'] = "Naudotojų grupės narystė";
$PMF_LANG['ad_group_members'] = "Nariai";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Riboti eksportuojamus DUK duomenis (nebūtinai)';
$PMF_LANG['ad_export_cat_downwards'] = 'Ir pogrupius?';
$PMF_LANG['ad_export_type'] = 'Eksporto formatas';
$PMF_LANG['ad_export_type_choose'] = 'Parinkite vieną iš palaikomų formatų:';
$PMF_LANG['ad_export_download_view'] = 'Atsiųsti ar peržiūrėti tiesiogiai?';
$PMF_LANG['ad_export_download'] = 'atsiųsti';
$PMF_LANG['ad_export_view'] = 'peržiūrėti tiesiogiai';
$PMF_LANG['ad_export_gen_xhtml'] = 'Sukurti XHTML failą';
$PMF_LANG['ad_export_gen_docbook'] = 'Sukurti Docbook failą';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'Naujienos data';
$PMF_LANG['ad_news_author_name'] = 'Autoriaus vardas:';
$PMF_LANG['ad_news_author_email'] = 'Autoriaus el. pašto adresas:';
$PMF_LANG['ad_news_set_active'] = 'Aktyvinti';
$PMF_LANG['ad_news_allowComments'] = 'Leisti komentarus:';
$PMF_LANG['ad_news_expiration_window'] = 'Naujienos galiojimo laiko rėžis (nebūtinas)';
$PMF_LANG['ad_news_from'] = 'Nuo:';
$PMF_LANG['ad_news_to'] = 'Iki:';
$PMF_LANG['ad_news_insertfail'] = 'Įvyko klaida įterpiant naujienos įrašą į duomenų bazę.';
$PMF_LANG['ad_news_updatefail'] = 'Įvyko klaida atnaujinant naujienos įrašą į duomenų bazėje.';
$PMF_LANG['newsShowCurrent'] = 'Rodyti dabartines naujienas.';
$PMF_LANG['newsShowArchive'] = 'Rodyti archyvuotas naujienas.';
$PMF_LANG['newsArchive'] = ' – naujienų archyvas';
$PMF_LANG['newsWriteComment'] = 'komentuoti šį įrašą';
$PMF_LANG['newsCommentDate'] = 'Pridėta: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Įrašo galiojimo laiko rėžis (nebūtinas)';
$PMF_LANG['admin_mainmenu_home'] = 'Panelė';
$PMF_LANG['admin_mainmenu_users'] = 'Naudotojai';
$PMF_LANG['admin_mainmenu_content'] = 'Turinys';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistika';
$PMF_LANG['admin_mainmenu_exports'] = 'Eksportas';
$PMF_LANG['admin_mainmenu_backup'] = 'Atsarginė kopija';
$PMF_LANG['admin_mainmenu_configuration'] = 'Konfigūracija';
$PMF_LANG['admin_mainmenu_logout'] = 'Atsijungti';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Grupės valdytojas';
$PMF_LANG['adminSection'] = 'Administravimas';
$PMF_LANG['err_expiredArticle'] = 'Šis įrašas nebegalioja ir negali būti parodytas';
$PMF_LANG['err_expiredNews'] = 'Ši naujiena nebegalioja ir negali būti parodyta';
$PMF_LANG['err_inactiveNews'] = 'Ši naujiena turi pataisą ir negali būti parodyta';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Ieškoti visomis kalbomis:';
$PMF_LANG['ad_entry_tags'] = 'Gairės';
$PMF_LANG['msg_tags'] = 'Gairės';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Tikrinama...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Tikrinama...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Tikrinama...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Tikrinama...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Išjungta';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Saitai negeri';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Saitai geri';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'Nėra prieigos';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'Nėra AJAX';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Nėra saitų';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Nėra scenarijų';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'Susiję įrašai';
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "Susijusių įrašų skaičius");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Išversti';
$PMF_LANG['ad_categ_trans_2'] = 'grupę';
$PMF_LANG['ad_categ_translatecateg'] = 'Išversti grupę';
$PMF_LANG['ad_categ_translate'] = 'Išversti';
$PMF_LANG['ad_categ_transalready'] = 'Jau išversta į: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Šalinti visomis kalbomis?';
$PMF_LANG["ad_categ_deletethislang"] = 'Šalinti tik šia kalba?';
$PMF_LANG["ad_categ_translated"] = "Grupė buvo išversta.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "Apžvalga";
$PMF_LANG['ad_menu_categ_structure'] = "Grupių ir jų vertimų apžvalga";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Naudotojo teisės:';
$PMF_LANG['ad_entry_grouppermission'] = 'Naudotojų grupės teisės:';
$PMF_LANG['ad_entry_all_users'] = 'Prieiga visiems naudotojams';
$PMF_LANG['ad_entry_restricted_users'] = 'Ribotoji prieiga';
$PMF_LANG['ad_entry_all_groups'] = 'Prieiga visoms grupėms';
$PMF_LANG['ad_entry_restricted_groups'] = 'Ribotoji prieiga';
$PMF_LANG['ad_session_expiration'] = 'Laikas iki seanso galiojimo pabaigos';
$PMF_LANG['ad_user_active'] = 'aktyvus';
$PMF_LANG['ad_user_blocked'] = 'blokuotas';
$PMF_LANG['ad_user_protected'] = 'apsaugotas';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Pasirinkite DUK įrašą, norėdami jį įterpti kaip nuorodą...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Įdėti po";
$PMF_LANG["ad_categ_remark_move"] = "Dviejų grupių sukeitimas įmanomas tik tame pačiame lygyje.";
$PMF_LANG["ad_categ_remark_overview"] = "Grupės bus rodomos teisinga tvarka, jei visos grupės yra apibrėžtos dabartinėje kalboje (pirmas stulpelis).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d svečių ir %d registruotų';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Iš karto šalinti žurnalo įrašus senesnius kaip 30 dienų';
$PMF_LANG['ad_adminlog_delete_success'] = 'Senesni žurnalo įrašai sėkmingai pašalinti.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Žurnalo įrašai nepašalinti: įvyko klaida vykdant užklausą.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'pridėti paieškos papildinį';
$PMF_LANG['ad_quicklinks'] = 'Spartieji saitai';
$PMF_LANG['ad_quick_category'] = 'Pridėti naują grupę';
$PMF_LANG['ad_quick_record'] = 'Pridėti naują DUK įrašą';
$PMF_LANG['ad_quick_user'] = 'Pridėti naują naudotoją';
$PMF_LANG['ad_quick_group'] = 'Pridėti naują naudotojų grupę';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Vertimo pasiūlymas';
$PMF_LANG['msgNewTranslationAddon'] = 'Jūsų pasiūlymas nebus iš karto paskelbtas. Jis bus paskelbtas tik gavus administratoriaus sutikimą. Būtini laukai yra <strong>jūsų vardas</strong>, <strong>jūsų el. pašto adresas</strong>, <strong>jūsų vertimo antraštė</strong> ir <strong>jūsų DUK vertimas</strong>. Prašome atskirti raktažodžius tik tarpais.';
$PMF_LANG['msgNewTransSourcePane'] = 'Šaltinio polangis';
$PMF_LANG['msgNewTranslationPane'] = 'Vertimo polangis';
$PMF_LANG['msgNewTranslationName'] = "Jūsų vardas";
$PMF_LANG['msgNewTranslationMail'] = "Jūsų el. pašto adresas";
$PMF_LANG['msgNewTranslationKeywords'] = "Raktažodžiai";
$PMF_LANG['msgNewTranslationSubmit'] = 'Išsiųsti pasiūlymą';
$PMF_LANG['msgTranslate'] = 'Pasiūlyti vertimą į';
$PMF_LANG['msgTranslateSubmit'] = 'Pradėti vertimą...';
$PMF_LANG['msgNewTranslationThanks'] = "Ačiū už jūsų vertimo pasiūlymą!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "pridėti naudotojų grupių paskyras";
$PMF_LANG["rightsLanguage"]['editgroup'] = "redaguoti naudotojų grupių paskyras";
$PMF_LANG["rightsLanguage"]['delgroup'] = "šalinti naudotojų grupių paskyras";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Saitas atveriamas pagrindiniame lange';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Komentarai';
$PMF_LANG['ad_comment_administration'] = 'Komentarų administravimas';
$PMF_LANG['ad_comment_faqs'] = 'Komentarai DUK įrašuose:';
$PMF_LANG['ad_comment_news'] = 'Komentarai naujienų įrašuose:';
$PMF_LANG['ad_groups'] = 'Grupės';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Įrašų rikiavimas (pagal savybes)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Įrašų rikiavimas (didėjančiai ar mažėjančiai)');
$PMF_LANG['ad_conf_order_id'] = 'Identifikatorius (numatytas)';
$PMF_LANG['ad_conf_order_thema'] = 'Antraštė';
$PMF_LANG['ad_conf_order_visits'] = 'Lankytojų skaičius';
$PMF_LANG['ad_conf_order_updated'] = 'Data';
$PMF_LANG['ad_conf_order_author'] = 'Autorius';
$PMF_LANG['ad_conf_desc'] = 'mažėjančiai';
$PMF_LANG['ad_conf_asc'] = 'didėjančiai';
$PMF_LANG['mainControlCenter'] = 'Pagrindinė konfigūracija';
$PMF_LANG['recordsControlCenter'] = 'DUK įrašų konfigūracija';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Aktyvinti naujus įrašus (numatyta r.: neaktyvinti)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Leisti komentarus naujiems įrašams (numatyta r.: neleisti)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Įrašai šioje grupėje';
$PMF_LANG['msgTagSearch'] = 'Įrašai su gairėmis';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ informacija';
$PMF_LANG['ad_online_info'] = 'Tiesioginis versijos tikrinimas';
$PMF_LANG['ad_system_info'] = 'Sistemos informacija';

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG['msgRegisterUser'] = 'Ar norite registruotis?';
$PMF_LANG["ad_user_loginname"] = 'Prisijungimo vardas:';
$PMF_LANG['errorRegistration'] = 'Šis laukas yra būtinas!';
$PMF_LANG['submitRegister'] = 'Registruotis';
$PMF_LANG['msgUserData'] = 'Naudotojo informacija reikalinga registracijai';
$PMF_LANG['captchaError'] = 'Prašome įvesti teisingą CAPTCHA kodą!';
$PMF_LANG['msgRegError'] = 'Įvyko šios klaidos. Prašome jas ištaisyti:';
$PMF_LANG['successMessage'] = 'Jūsų registracija sėkminga. Jūs netrukus gausite patvirtinimo laišką su prisijungimo duomenimis!';
$PMF_LANG['msgRegThankYou'] = 'Ačiū jums už jūsų registraciją';
$PMF_LANG['emailRegSubject'] = '[%sitename%] registracija: naujas naudotojas';

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG['msgMostPopularSearches'] = 'Populiariausios paieškos yra:';
$LANG_CONF['main.enableWysiwygEditor'] = array(0 => "checkbox", 1 => "Įjungti pridėtinį WYSIWYG redaktorių (numatyta r.: įjungti)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG['ad_menu_searchstats'] = 'Paieškos statistika';
$PMF_LANG['ad_searchstats_search_term'] = 'Raktažodis';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Skaičius';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Kalba';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Procentai';

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG['ad_record_sticky'] = 'Lipnus';
$PMF_LANG['ad_entry_sticky'] = 'Lipnus';
$PMF_LANG['stickyRecordsHeader'] = 'Lipnūs DUK';

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Atmetiniai';
$PMF_LANG['ad_config_stopword_input'] = 'Pridėti naują atmetinį';

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG['msgSendMailDespiteEverything'] = 'Ne, vis dar nėra adekvataus atsakymo (išsiųsime laišką)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'Ar norimas atsakymas yra rezultatų sąraše aukščiau?';

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Prašome išrinkti kalbą vertimui';
$PMF_LANG['msgLangDirIsntWritable'] = 'Vertimų katalogas nėra įrašomas';
$PMF_LANG['ad_menu_translations'] = 'Sąsajos vertimas';
$PMF_LANG['ad_start_notactive'] = 'Laukia aktyvinimo';

// added 2.5.0-RC - 2009-05-20 by Anatoliy
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Pridėti naują vertimą';
$PMF_LANG['msgTransToolLanguage'] = 'Kalba';
$PMF_LANG['msgTransToolActions'] = 'Veiksmai';
$PMF_LANG['msgTransToolWritable'] = 'Įrašomas';
$PMF_LANG['msgEdit'] = 'Redaguoti';
$PMF_LANG['msgDelete'] = 'Šalinti';
$PMF_LANG['msgYes'] = 'taip';
$PMF_LANG['msgNo'] = 'ne';
$PMF_LANG['msgTransToolSureDeleteFile'] = 'Ar tikrai pašalinti šį kalbos failą?';
$PMF_LANG['msgTransToolFileRemoved'] = 'Kalbos failas sėkmingai pašalintas';
$PMF_LANG['msgTransToolErrorRemovingFile'] = 'Klaida šalinant kalbos failą';
$PMF_LANG['msgVariable'] = 'Kintamasis';
$PMF_LANG['msgCancel'] = 'Atsisakyti';
$PMF_LANG['msgSave'] = 'Išsaugoti';
$PMF_LANG['msgSaving3Dots'] = 'saugoma ...';
$PMF_LANG['msgRemoving3Dots'] = 'šalinama ...';
$PMF_LANG['msgTransToolFileSaved'] = 'Kalbos failas sėkmingai išsaugotas';
$PMF_LANG['msgTransToolErrorSavingFile'] = 'Klaida saugant kalbos failą';
$PMF_LANG['msgLanguage'] = 'Kalba';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Kalbos ženklų rinkinys';
$PMF_LANG['msgTransToolLanguageDir'] = 'Kalbos kryptis';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Kalbos aprašas';
$PMF_LANG['msgAuthor'] = 'Autorius';
$PMF_LANG['msgTransToolAddAuthor'] = 'Pridėti autorių';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Sukurti vertimą';
$PMF_LANG['msgTransToolTransCreated'] = 'Naujas vertimas sėkmingai sukurtas';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Nepavyko sukurti naujo vertimo';
$PMF_LANG['msgAdding3Dots'] = 'pridedama ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Siųsti phpMyFAQ komandai';
$PMF_LANG['msgSending3Dots'] = 'siunčiama ...';
$PMF_LANG['msgTransToolFileSent'] = 'Kalbos failas sėkmingai išsiųstas phpMyFAQ komandai. Labai ačiū už failo pasidalinimą.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Įvyko klaida siunčiant kalbos failą';
$PMF_LANG['msgTransToolPercent'] = 'Procentai';

// added 2.5.0-RC3 - 2009-06-23 by Anatoliy
$LANG_CONF['records.attachmentsPath'] = array(0 => "input", 1 => "Kelias, kur bus saugomi priedai.<br><small>Santykinis kelias reiškia katalogą žiniatinklio šakniniame kataloge</small>");

// added 2.5.0-RC3 - 2009-06-24 by Anatoliy
$PMF_LANG['msgAttachmentNotFound'] = "Failas, kurį mėginate atsisiųsti buvo nerastas serveryje";

// added 2.6.0-alpha - 2009-07-30 by Aurimas Fišeras - Plural messages
$PMF_LANG["plmsgUserOnline"][0] = "%d prisijungęs naudotojas";
$PMF_LANG["plmsgUserOnline"][1] = "%d prisijungę naudotojai";
$PMF_LANG["plmsgUserOnline"][2] = "%d prisijungusių naudotojų";

// added 2.6.0-alpha - 2009-08-02 by Anatoliy
$LANG_CONF['main.templateSet'] = array(0 => "select", 1 => "Naudojamas šablonų rinkinys");

// added 2.6.0-alpha - 2009-08-16 by Aurimas Fišeras
$PMF_LANG['msgTransToolRemove'] = 'Šalinti';
$PMF_LANG["msgTransToolLanguageNumberOfPlurals"] = "Daugiskaitos formų skaičius";
$PMF_LANG['msgTransToolLanguageOnePlural'] = 'Ši kalba turi tik vieną daugiskaitos formą';
$PMF_LANG['msgTransToolLanguagePluralNotSet'] = "Daugiskaitos formų palaikymas kalbai „%s“ neįjungtas („nplurals“ reikšmė nenustatyta)";

// added 2.6.0-alpha - 2009-08-16 by Aurimas Fišeras - Plural messages
$PMF_LANG["plmsgHomeArticlesOnline"][0] = "Yra pateiktas %d DUK";
$PMF_LANG["plmsgHomeArticlesOnline"][1] = "Yra pateikti %d DUK";
$PMF_LANG["plmsgHomeArticlesOnline"][2] = "Yra pateikta %d DUK";
$PMF_LANG["plmsgViews"][0] = "%d peržiūra";
$PMF_LANG["plmsgViews"][1] = "%d peržiūros";
$PMF_LANG["plmsgViews"][2] = "%d peržiūrų";

// added 2.6.0-alpha - 2009-08-30 by Aurimas Fišeras - Plural messages
$PMF_LANG['plmsgGuestOnline'][0] = '%d svečias';
$PMF_LANG['plmsgGuestOnline'][1] = '%d svečiai';
$PMF_LANG['plmsgGuestOnline'][2] = '%d svečių';
$PMF_LANG['plmsgRegisteredOnline'][0] = ' ir %d registruotas';
$PMF_LANG['plmsgRegisteredOnline'][1] = ' ir %d registruoti';
$PMF_LANG['plmsgRegisteredOnline'][2] = ' ir %d registruotų';
$PMF_LANG["plmsgSearchAmount"][0] = "%d paieškos rezultatas";
$PMF_LANG["plmsgSearchAmount"][1] = "%d paieškos rezultatai";
$PMF_LANG["plmsgSearchAmount"][2] = "%d paieškos rezultatų";
$PMF_LANG["plmsgPagesTotal"][0] = " %d puslapio";
$PMF_LANG["plmsgPagesTotal"][1] = " %d puslapių";
$PMF_LANG["plmsgPagesTotal"][2] = " %d puslapių";
$PMF_LANG["plmsgVotes"][0] = "%d balsas";
$PMF_LANG["plmsgVotes"][1] = "%d balsai";
$PMF_LANG["plmsgVotes"][2] = "%d balsų";
$PMF_LANG["plmsgEntries"][0] = "%d DUK";
$PMF_LANG["plmsgEntries"][1] = "%d DUK";
$PMF_LANG["plmsgEntries"][2] = "%d DUK";

// added 2.6.0-alpha - 2009-09-06 by Aurimas Fišeras
$PMF_LANG["rightsLanguage"]['addtranslation'] = "pridėti vertimą";
$PMF_LANG["rightsLanguage"]['edittranslation'] = "redaguoti vertimą";
$PMF_LANG["rightsLanguage"]['deltranslation'] = "šalinti vertimą";
$PMF_LANG["rightsLanguage"]['approverec'] = "patvirtinti įrašus";

// added 2.6.0-alpha - 2009-09-9 by Anatoliy Belsky
$LANG_CONF["records.enableAttachmentEncryption"] = array(0 => "checkbox", 1 => "Įjungti priedų užšifravimą <br><small>Ignoruojama, kai priedai išjungti</small>");
$LANG_CONF["records.defaultAttachmentEncKey"] = array(0 => "input", 1 => 'Numatytasis priedų užšifravimo raktas <br><small>Ignoruojama, jei priedų užšifravimas išjungtas</small><br><small><font color="red">ĮSPĖJIMAS: Nekeiskite šio rakto, kai užšifravimas jau įjungtas!!!</font></small>');
//$LANG_CONF["records.attachmentsStorageType"] = array(0 => "select", 1 => "Attachment storage type");
//$PMF_LANG['att_storage_type'][0] = 'Failų sistema';
//$PMF_LANG['att_storage_type'][1] = 'Duomenų bazė';

// added 2.6.0-alpha - 2009-09-06 by Thorsten
$PMF_LANG['ad_menu_upgrade'] = 'Atnaujinti';
$PMF_LANG['ad_you_shouldnt_update'] = 'Jūs turite naujausią phpMyFAQ versiją. Jums nereikia atnaujinti.';
$LANG_CONF['security.useSslForLogins'] = array(0 => 'checkbox', 1 => "Leisti prisijungimus tik per saugujį ryšį? (numatyta r.: išjungta)");
$PMF_LANG['msgSecureSwitch'] = "Jei norite prisijungti, persijunkite į saugujį režimą!";

// added 2.6.0-alpha - 2009-10-03 by Anatoliy Belsky
$PMF_LANG['msgTransToolNoteFileSaving'] = 'Pastebėkite, kad jokie failai nebus įrašyti kol nepaspausite mygtuko išsaugoti';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'Puslapio %d buferis sėkmingai įrašytas';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'Klaida įrašant puslapio %d buferį';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'Įrašomas puslapio %d buferis';

// added 2.6.0-alpha - 2009-11-02 by Anatoliy Belsky
$PMF_LANG['ad_record_active'] = 'Aktyvus';

// added 2.6.0-alpha - 2009-11-01 by Anatoliy Belsky
$PMF_LANG['msgAttachmentInvalid'] = 'Priedas yra blogas, informuokite administratorių';

// added 2.6.0-alpha - 2009-11-02 by max
$LANG_CONF['search.numberSearchTerms'] = array(0 => 'input', 1 => 'Rodomų paieškos raktažodžių skaičius');
$LANG_CONF['records.orderingPopularFaqs'] = array(0 => "select", 1 => "Populiariausių DUK rikiavimas");
$PMF_LANG['list_all_users'] = 'Rodyti visus naudotojus';

$PMF_LANG['records.orderingPopularFaqs.visits'] = "rodyti dažniausiai peržiūrėtus įrašus";
$PMF_LANG['records.orderingPopularFaqs.voting'] = "rodyti geriausiai įvertintus įrašus";

// added 2.6.0-alpha - 2009-11-05 by Thorsten
$PMF_LANG['msgShowHelp'] = 'Prašome atskirti žodžius kableliu.';

// added 2.6.0-RC - 2009-11-30 by Thorsten
$PMF_LANG['msgUpdateFaqDate'] = 'atnaujinti';
$PMF_LANG['msgKeepFaqDate'] = 'palikti'; 
$PMF_LANG['msgEditFaqDat'] = 'redaguoti';
$LANG_CONF['main.optionalMailAddress'] = array(0 => 'checkbox', 1 => 'El. pašto adresas yra būtinas laukas (numatyta r.: išjungta)');
